/**
 * 
 */
package gov.va.med.mhv.usermgmt.mvi.client;

import javax.jms.JMSException;
import javax.jms.Message;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator;

/**
 * @author PII
 *
 */
public class JmsMviTreatmentFacilityUpdateClient implements MviTreatmentFacilityUpdator {
	
	protected static final Logger LOGGER = LogManager.getLogger(JmsMviTreatmentFacilityUpdateClient.class);
	
	private JmsTemplate jmsTemplate;
	
	@Override
	public void updateTreatmentFacilitiesForExistingPatients(PatientDTO patientDTO) throws MHVException {
		
		try {
			
			this.jmsTemplate.convertAndSend(patientDTO, new MessagePostProcessor() {
				
				@Override
				public Message postProcessMessage(Message message) throws JMSException {
					message.setStringProperty("JavaType", "PatientDTO");
					return message;
				}
			});
		} catch ( Exception ex ) {
			String message = "Error sending PatientDTO asynchronously.";
			LOGGER.error(message);
			throw new MHVException(message, ex);
		}
		
	}
	
	public void setJmsTemplate(JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

}
